'use strict';

/**
 * Read the documentation (https://strapi.io/documentation/developer-docs/latest/development/backend-customization.html#core-controllers)
 * to customize this controller
 */
 const { sanitizeEntity } = require('strapi-utils');

 module.exports = {
    list: async (ctx) => {
        const {categorias_in, nombre_contains } = ctx.query
        let totalProducts;
        let products;
        let entities;
        let params= { published_at_null: 'false', }
      if(categorias_in) params.categorias_in=categorias_in;
      if(nombre_contains) params.nombre_contains = nombre_contains;
        totalProducts = await strapi.services['maquinaria'].count(params);
        entities = await strapi.services['maquinaria'].find(ctx.query);
        products = entities.map(entity => sanitizeEntity(entity, {model: strapi.models['maquinaria']}))
      ctx.send({error: false, products: products, totalItems:totalProducts})
  },
  relateds: async (ctx) => {
      let products;
      let entities = await strapi.services['maquinaria'].find(ctx.query)
      products = entities.map(entity => sanitizeEntity(entity, {model: strapi.models['maquinaria']}))
      if(products.length >= 8){
        ctx.send(products)
      }else{
        let nin=[]
        if(products.length > 0){
          nin = products.map(el=>el.id)
          if(ctx.query.id_nin) nin.push(Number(ctx.query.id_nin));
          ctx.query.id_nin=nin;
        }
        ctx.query._limit = 8-products.length;
        let entit = await strapi.services['maquinaria'].find(ctx.query)
        let otherProducts = entit.map(ent => sanitizeEntity(ent, {model: strapi.models['maquinaria']}))
        if(products.length > 0) products = products.concat(otherProducts);
        if(products.length>=8){
          ctx.send(products)
        }else{
          let query = {
            _limit: 8 - products.length,
            _sort: 'created_at:desc',
            id_nin: ctx.query.id_nin
          }
          let any = await strapi.services['maquinaria'].find(query)
          let anySanitized = any.map(val => sanitizeEntity(val, {model: strapi.models['maquinaria']}))
          if(products.length > 0){
            products = products.concat(anySanitized);
          }else{
            products = anySanitized;
          }
          ctx.send(products)
        }
      }
  },
  productsByCategory: async (ctx) => {
    const knex = strapi.connections.default;
    const _ = require('lodash');  
    const result = await knex('productos').join('categorias', 'productos.categoria', 'categorias.id')
    ctx.send(result)
  }
}