// File /api/email/controllers/Email.js
'use strict'

/**
 * Read the documentation () to implement custom controller functions
 */

module.exports = {
  /**
   * Sends an email to the recipient in the body of the request
   */
  send: async (ctx) => {
    const body = ctx.request.body    
    strapi.log.debug(`Trying to send an email to ${body.email}`)
    try {
      const emailOptions = {
        to: body.email,
        subject: body.asunto,
        html: `${body.html}`,
      }
      let info = await strapi.plugins['email'].services.email.send(emailOptions)
      strapi.log.debug(`Email sent to ${body.email}`)
      ctx.send({ error:false, message: 'Notificado por correo' })
    } catch (err) {
      strapi.log.error(`Error sending email to ${body.email}`, err)
      ctx.send({ error: true, message: 'Error al enviar correo' })
    }
  },
}