'use strict';

const { sanitizeEntity } = require('strapi-utils');

module.exports = {

  async find(ctx){
    const { slug, _limit,_start, _sort, categorias_in } = ctx.query
    let entities;
    var publicaciones;
    var publicacion
    let totalArticles
    if(slug != undefined){
      entities = await strapi.services['blog-publicacion'].find(ctx.query);
      publicacion =  entities.map(entity => {
        let publicacionSanitized = sanitizeEntity(entity, {model: strapi.models['blog-publicacion']});
        publicacionSanitized.contenido = publicacionSanitized.contenido.replace('src="/', `src="${strapi.config.get('server.url')}/`);
        publicacionSanitized.excerpt = publicacionSanitized.contenido.replace( /(<([^>]+)>)/ig, '').slice(0,145)+"...";
        return publicacionSanitized;
      })
      return publicacion
    }else{
      if(_start != undefined) {
        if(categorias_in){
          totalArticles = await strapi.services['blog-publicacion'].count({ published_at_null: 'false',categorias_in:Number(categorias_in) });
        }else{
          totalArticles = await strapi.services['blog-publicacion'].count({ published_at_null: 'false' });
        }
      }
      entities = await strapi.services['blog-publicacion'].find(ctx.query);
      publicaciones = entities.map(entity => {
        var publicacion = sanitizeEntity(entity, {model: strapi.models['blog-publicacion']});
        if(_start != undefined || _limit) publicacion.excerpt = publicacion.contenido.replace( /(<([^>]+)>)/ig, '').slice(0,100)+"...";
        return publicacion;
      })
      return { totalArticles: totalArticles, publicaciones: publicaciones }
    }
  }
};