'use strict';
const slugify = require('slugify');

module.exports = {
  /**
   * Triggered before user creation.
   */
  lifecycles: {
    async beforeCreate(data) {
      if (data.title) {
        data.slug = slugify(data.nombre, {lower: true});
      }
    },
    async beforeUpdate(params, data) {
      if (data.nombre) {
        data.slug = slugify(data.nombre, {lower: true});
      }
    },
  },
};