import React from 'react';
import { Flex, Padded, Text } from '@buffetjs/core';
import { LoadingIndicator } from 'strapi-helper-plugin';
import PropTypes from 'prop-types';
import BaselineAlignement from '../BaselineAlignement';
import Bloc from '../Bloc';

const FormBloc = ({ children, actions, isLoading, title, subtitle }) => (
  <Bloc>
    <BaselineAlignement top size={title ? '18px' : '22px'} />
    <Padded left right size="sm">
      {isLoading ? (
        <>
          <LoadingIndicator />
          <BaselineAlignement bottom size="22px" />
        </>
      ) : (
        <>
          {title && (
            <>
              <Padded left right size="xs">
                <Flex justifyContent="space-between">
                  <Padded left right size="sm">
                    <Text fontSize="lg" fontWeight="bold">
                      {title}
                    </Text>
                    {subtitle && (
                      <Text color="grey" lineHeight="1.8rem">
                        {subtitle}
                      </Text>
                    )}
                  </Padded>
                  {actions}
                </Flex>
              </Padded>
              <BaselineAlignement top size="18px" />
            </>
          )}
          {children}
        </>
      )}
    </Padded>
  </Bloc>
);

FormBloc.defaultProps = {
  actions: null,
  isLoading: false,
  subtitle: null,
  title: null,
};

FormBloc.propTypes = {
  actions: PropTypes.any,
  children: PropTypes.node.isRequired,
  isLoading: PropTypes.bool,
  subtitle: PropTypes.string,
  title: PropTypes.string,
};

export default FormBloc;
