import React from 'react';
import PropTypes from 'prop-types';

const IconUpload = ({ title, ...props }) => {
  return (
    <svg
      width="105"
      height="84"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <title>{title}</title>
      <defs>
        <rect id="a" y="1.354" width="77.333" height="62.292" rx="4" />
        <rect id="b" y="1.354" width="77.333" height="62.292" rx="4" />
      </defs>
      <g fill="none" fillRule="evenodd" opacity=".05">
        <g transform="rotate(-12 75.8 12.214)">
          <use fill="#FAFAFB" xlinkHref="#a" />
          <rect stroke="#979797" x=".5" y="1.854" width="76.333" height="61.292" rx="4" />
        </g>
        <path
          d="M74.255 36.05l3.942 18.544-57.385 12.198-1.689-7.948L29.35 42.827l7.928 5.236 16.363-25.628L74.255 36.05zM71.974 6.078l-65.21 13.86a1.272 1.272 0 0 0-.833.589 1.311 1.311 0 0 0-.19 1.014l10.7 50.334c.076.358.27.641.584.849.314.207.648.273 1.001.198l65.21-13.86c.353-.076.63-.272.833-.589.203-.317.266-.655.19-1.014l-10.7-50.334a1.311 1.311 0 0 0-.584-.849 1.272 1.272 0 0 0-1.001-.198zm6.803-.061L89.475 56.35c.387 1.822.08 3.517-.921 5.085-1.001 1.568-2.399 2.543-4.192 2.924L19.152 78.22c-1.793.381-3.466.06-5.019-.966-1.552-1.026-2.522-2.45-2.91-4.27L.525 22.65c-.387-1.822-.08-3.517.921-5.085 1.001-1.568 2.399-2.543 4.192-2.924L70.848.78c1.793-.381 3.466-.06 5.019.966 1.552 1.026 2.522 2.45 2.91 4.27z"
          fill="#333740"
          fillRule="nonzero"
        />
        <g>
          <g transform="rotate(15 7.723 110.16)">
            <use fill="#FAFAFB" xlinkHref="#b" />
            <rect stroke="#979797" x=".5" y="1.854" width="76.333" height="61.292" rx="4" />
          </g>
          <path
            d="M49.626 26.969c-.584 2.18-1.832 3.832-3.744 4.955-1.911 1.123-3.94 1.398-6.086.822-2.147-.575-3.767-1.827-4.86-3.755-1.094-1.929-1.35-3.983-.765-6.163.584-2.18 1.832-3.832 3.743-4.955 1.912-1.124 3.94-1.398 6.087-.823s3.767 1.827 4.86 3.756c1.094 1.928 1.349 3.983.765 6.163zm37.007 26.74L81.726 72.02 25.058 56.836l2.103-7.848 16.384-9.63 4.687 8.266 26.214-15.406 12.187 21.49zm11.574-27.742L33.812 8.712a1.272 1.272 0 0 0-1.01.146c-.324.19-.533.463-.628.817L18.855 59.38c-.095.354-.05.695.136 1.022.186.327.453.538.802.631l64.395 17.255c.349.093.685.045 1.01-.146.324-.19.533-.463.628-.817L99.145 27.62c.095-.354.05-.695-.136-1.022a1.272 1.272 0 0 0-.802-.631zm6.09 3.033l-13.32 49.705c-.481 1.799-1.524 3.17-3.128 4.112-1.605.943-3.292 1.177-5.063.703L18.39 66.265c-1.771-.474-3.115-1.52-4.033-3.14-.918-1.618-1.136-3.327-.654-5.125L27.022 8.295c.482-1.799 1.525-3.17 3.13-4.112 1.604-.943 3.291-1.177 5.062-.703L99.61 20.735c1.771.474 3.115 1.52 4.033 3.14.918 1.618 1.136 3.327.654 5.125z"
            fill="#333740"
            fillRule="nonzero"
          />
        </g>
      </g>
    </svg>
  );
};

IconUpload.propTypes = {
  title: PropTypes.string.isRequired,
};

export default IconUpload;
