import ar from './ar.json';
import cs from './cs.json';
import de from './de.json';
import dk from './dk.json';
import en from './en.json';
import es from './es.json';
import fr from './fr.json';
import he from './he.json';
import id from './id.json';
import it from './it.json';
import ja from './ja.json';
import ko from './ko.json';
import ms from './ms.json';
import nl from './nl.json';
import no from './no.json';
import pl from './pl.json';
import ptBR from './pt-BR.json';
import pt from './pt.json';
import ru from './ru.json';
import th from './th.json';
import tr from './tr.json';
import vi from './vi.json';
import zhHans from './zh-Hans.json';
import zh from './zh.json';
import sk from './sk.json';
import uk from './uk.json';

const trads = {
  ar,
  cs,
  de,
  dk,
  en,
  es,
  fr,
  he,
  id,
  it,
  ja,
  ko,
  ms,
  nl,
  no,
  pl,
  'pt-BR': ptBR,
  pt,
  ru,
  sk,
  th,
  tr,
  uk,
  vi,
  'zh-Hans': zhHans,
  zh,
};

export const languageNativeNames = {
  ar: 'العربية',
  cs: 'Čeština',
  de: 'Deutsch',
  dk: 'Dansk',
  en: 'English',
  es: 'Español',
  fr: 'Français',
  he: 'עברית',
  id: 'Indonesian',
  it: 'Italiano',
  ja: '日本語',
  ko: '한국어',
  ms: 'Melayu',
  nl: 'Nederlands',
  no: 'Norwegian',
  pl: 'Polski',
  'pt-BR': 'Português (Brasil)',
  pt: 'Português (Portugal)',
  ru: 'Русский',
  sk: 'Slovenčina',
  th: 'ไทย',
  tr: 'Türkçe',
  uk: 'Українська',
  vi: 'Tiếng Việt',
  'zh-Hans': '中文 (简体)',
  zh: '中文 (繁體)',
};

export default trads;
